/*===================================================================*/
/* Author: Luis Cludio Oliveira Almeida                             */
/* Date: Outubro 2002                                                */
/* lcoalmeida@yahoo.com                                              */
/*===================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#define BUF_SIZE 16
#define NUM_SIZE 64
#define NUM_DEC_DIGITS 11

/* Structure that defines complex numbers. */
typedef struct __cnumber {
	double a; /* Real part. */
	double b; /* Imaginary part. */
} cnumber;

cnumber *roots; /* vector that stores the roots of the polynomial of characteristic exponents. */

int n, k;		/* determines the number choose n, k of the roots to be added up. */

int v[BUF_SIZE];/* numerical vector of terms to be added up. */

double const_error;

time_t t;

unsigned long int counter; /* counts the sums that have already been performed. */

char *error1 = "The integer part of one of the numbers is greater than 9. See section 5 of paper ON HOMOGENEOUS MINIMAL INVOLUTIVE VARIETIES.";
char *error2 = "Integer sum.";

void sum_roots2(int parts);

int is_integer(double n);

int is_null(double n);

void print_error(char *msg, int parts, double a, double b);

int main(void) {

	int i, j;
	char a[NUM_SIZE], b[NUM_SIZE];
	FILE *in;

	counter = 0;
	const_error = pow(10,-1*NUM_DEC_DIGITS);

		
	/* Inicializes the vector of combinations. */
	for(j=0;j<BUF_SIZE;j++)
   		v[j] = 0;

	if((in = fopen("roots.txt","rt"))==NULL)
	{
   		fprintf(stderr, "Cannot open input file.\n");
		return 1;
	}

	/* Gets the number of roots. */
	fscanf(in,"%d\n",&n);

	printf("\n%d ROOTS:\n", n);

	roots = (cnumber*)malloc((n+1)*sizeof(cnumber));
	roots[0].a=0;
	roots[0].b=0;

	/* Gets each one of the roots. */
	for(i=1;i<=n;i++)
	{
 		fgets(a, NUM_SIZE, in);
		fgets(b, NUM_SIZE, in);
		roots[i].a = atof(a);
		roots[i].b = atof(b);
	}

  	for(i=1;i<=n;i++)
	{
   		printf("A[%d]=%.16f\n",i, roots[i].a); 
		printf("B[%d]=%.16f\n",i, roots[i].b);
	}

	fclose(in);

	t = time(NULL);

   /* Computes the combinations, beginning from 
       n, 1 and going all the way to  n, 15. */
	for(v[1]=1;v[1]<=n;v[1]++) {
		sum_roots2(1);
		for(v[2]=v[1]+1;v[2]<=n;v[2]++) {
			sum_roots2(2);
			for(v[3]=v[2]+1;v[3]<=n;v[3]++) {
				sum_roots2(3);
				for(v[4]=v[3]+1;v[4]<=n;v[4]++) {
					sum_roots2(4);
					for(v[5]=v[4]+1;v[5]<=n;v[5]++) {
						sum_roots2(5);
						for(v[6]=v[5]+1;v[6]<=n;v[6]++) {
							sum_roots2(6);
							for(v[7]=v[6]+1;v[7]<=n;v[7]++) {
								sum_roots2(7);
								for(v[8]=v[7]+1;v[8]<=n;v[8]++) {
									sum_roots2(8);
									for(v[9]=v[8]+1;v[9]<=n;v[9]++) {
										sum_roots2(9);
										for(v[10]=v[9]+1;v[10]<=n;v[10]++) {
											sum_roots2(10);
											for(v[11]=v[10]+1;v[11]<=n;v[11]++) {
												sum_roots2(11);
												for(v[12]=v[11]+1;v[12]<=n;v[12]++) {
													sum_roots2(12);
													for(v[13]=v[12]+1;v[13]<=n;v[13]++) {
														sum_roots2(13);
														for(v[14]=v[13]+1;v[14]<=n;v[14]++) {
															sum_roots2(14);
															for(v[15]=v[14]+1;v[15]<=n;v[15]++) {
																sum_roots2(15);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	
	printf("\n\nTotal sums: %ld", counter);
	printf("\n\nTotal time: %ld seconds", time(NULL)-t);
	
  	printf("\n\nThere are no integer sum.");
  	printf("\n\nP=0 is minimal involutive homogeneous.\n\n");

	free(roots);
	return 0;

}

/* sum_roots2: routine that adds up the roots selected by the present choice of k subset. */
void sum_roots2(int parts) {

	int i;
	double sum_a, sum_b;
	sum_a=0; sum_b=0;

	for(i=1;i<=parts;i++) 
	{
		sum_a += roots[v[i]].a;
   		sum_b += roots[v[i]].b;
	}

	/* If the integer part of the real part of the number is greater than 9 and the 
	   imaginary part is null, we assume the result is not reliable. */
	if(floor(sum_a)>9 && is_null(sum_b)) 
	{
		print_error(error1,parts,sum_a,sum_b);
		exit(0);
	}
	
	/* If the real part of the sum is integer and the imaginary part of the sum is null, 
	   we assume it is an integer. */
	if(is_integer(sum_a) && is_null(sum_b)) 
	{
		print_error(error2, parts, sum_a, sum_b);
		exit(0);    
	}

	counter++;

	if(counter%10000000==0) 
		printf("\n#sums: %ld\t#numbers added up: %d\tTime: %ld",counter, parts, time(NULL)-t);

}

/* is_integer: Given the number n of decimal digits we believe to be reliable,
   we assume that a number is an integer if either the first n decimal digits are
   equal to 9 or if they are equal to zero. */
int is_integer(double n) {

	double sum;
			
	if(is_null(n - floor(n))) 
		return 1;
			
	sum = n + const_error;
					
	if(is_null(sum - floor(sum))) 
		return 1;
	
	return 0;
}

/* is_null: Given the number n of decimal digits we believe to be reliable,
   we assume a number is zero if it is smaller than 10^(-n) . */
int is_null(double n) {

	if(n<0) 
		n = -n;
				
	if(n<const_error) 
		return 1;
	
	return 0;
}


void print_error(char *msg, int parts, double a, double b) {

	int i;
	printf("\n%s\n", msg);
	printf("\nRoots: ");
	for(i=1;i<=parts;i++)
       	printf("%d ",v[i]);
	printf("\nA=%.16f\tB=%.16f\n\n", a, b);
}